/*
 * Decompiled with CFR 0.152.
 */
package org.autoplot.dom;

import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import org.autoplot.dom.CanvasController;
import org.autoplot.dom.Column;
import org.autoplot.dom.Diff;
import org.autoplot.dom.DomNode;
import org.autoplot.dom.DomUtil;
import org.autoplot.dom.Row;

public class Canvas
extends DomNode {
    protected CanvasController controller;
    protected int height = 480;
    public static final String PROP_HEIGHT = "height";
    protected int width = 640;
    public static final String PROP_WIDTH = "width";
    protected boolean fitted = true;
    public static final String PROP_FITTED = "fitted";
    protected String font = "sans-10";
    public static final String PROP_FONT = "font";
    public static final String PROP_ROWS = "rows";
    protected List<Row> rows = new LinkedList<Row>();
    public static final String PROP_COLUMNS = "columns";
    protected List<Column> columns = new LinkedList<Column>();
    protected Row marginRow = new Row();
    public static final String PROP_MARGINROW = "marginRow";
    protected Column marginColumn;
    public static final String PROP_MARGINCOLUMN = "marginColumn";

    public Canvas() {
        this.marginRow.setTop("2em");
        this.marginRow.setBottom("100%-3em");
        this.marginColumn = new Column();
        this.marginColumn.setLeft("5em");
        this.marginColumn.setRight("100%-3em");
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int height) {
        CanvasController.resizeLogger.log(Level.FINE, "setHeight({0,number,#})", height);
        int oldHeight = this.height;
        this.height = height;
        this.propertyChangeSupport.firePropertyChange(PROP_HEIGHT, oldHeight, height);
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        CanvasController.resizeLogger.log(Level.FINE, "setWidth({0,number,#})", width);
        int oldWidth = this.width;
        this.width = width;
        this.propertyChangeSupport.firePropertyChange(PROP_WIDTH, oldWidth, width);
    }

    public void setSize(int width, int height) {
        CanvasController.resizeLogger.log(Level.FINE, "setSize({0,number,#},{1,number,#})", new Object[]{width, height});
        int oldWidth = this.width;
        int oldHeight = this.height;
        if (this.controller != null) {
            this.controller.dasCanvas.setSize(new Dimension(width, height));
        }
        if (width != oldWidth) {
            this.width = width;
        }
        if (height != oldHeight) {
            this.height = height;
        }
        if (width != oldWidth) {
            this.propertyChangeSupport.firePropertyChange(PROP_WIDTH, oldWidth, width);
        }
        if (height != oldHeight) {
            this.propertyChangeSupport.firePropertyChange(PROP_HEIGHT, oldHeight, height);
        }
    }

    public boolean isFitted() {
        return this.fitted;
    }

    public void setFitted(boolean fitted) {
        boolean oldfitted = this.fitted;
        this.fitted = fitted;
        this.propertyChangeSupport.firePropertyChange(PROP_FITTED, oldfitted, fitted);
    }

    public String getFont() {
        return this.font;
    }

    public void setFont(String font) {
        String oldFont = this.font;
        this.font = font;
        this.propertyChangeSupport.firePropertyChange(PROP_FONT, oldFont, font);
    }

    public Row[] getRows() {
        return this.rows.toArray(new Row[this.rows.size()]);
    }

    public void setRows(Row[] rows) {
        Row[] oldRows = this.rows.toArray(new Row[this.rows.size()]);
        this.rows = Arrays.asList(rows);
        this.propertyChangeSupport.firePropertyChange(PROP_ROWS, oldRows, rows);
    }

    public Row getRows(int index) {
        return this.rows.get(index);
    }

    public void setRows(int index, Row newRows) {
        Row oldRows = this.rows.get(index);
        this.rows.set(index, newRows);
        this.propertyChangeSupport.fireIndexedPropertyChange(PROP_ROWS, index, oldRows, newRows);
    }

    public Column[] getColumns() {
        return this.columns.toArray(new Column[this.columns.size()]);
    }

    public void setColumns(Column[] columns) {
        Column[] oldColumns = this.columns.toArray(new Column[this.columns.size()]);
        this.columns = Arrays.asList(columns);
        this.propertyChangeSupport.firePropertyChange(PROP_COLUMNS, oldColumns, columns);
    }

    public Column getColumns(int index) {
        return this.columns.get(index);
    }

    public void setColumns(int index, Column newColumns) {
        Column oldColumns = this.columns.get(index);
        this.columns.set(index, newColumns);
        this.propertyChangeSupport.fireIndexedPropertyChange(PROP_COLUMNS, index, oldColumns, newColumns);
    }

    public Row getMarginRow() {
        return this.marginRow;
    }

    public void setMarginRow(Row marginRow) {
        Row oldMarginRow = this.marginRow;
        this.marginRow = marginRow;
        this.propertyChangeSupport.firePropertyChange(PROP_MARGINROW, oldMarginRow, marginRow);
    }

    public Column getMarginColumn() {
        return this.marginColumn;
    }

    public void setMarginColumn(Column marginColumn) {
        Column oldMarginColumn = this.marginColumn;
        this.marginColumn = marginColumn;
        this.propertyChangeSupport.firePropertyChange(PROP_MARGINCOLUMN, oldMarginColumn, marginColumn);
    }

    public CanvasController getController() {
        return this.controller;
    }

    @Override
    public List<DomNode> childNodes() {
        ArrayList<DomNode> result = new ArrayList<DomNode>();
        result.add(this.marginRow);
        result.add(this.marginColumn);
        result.addAll(this.rows);
        result.addAll(this.columns);
        return result;
    }

    @Override
    public DomNode copy() {
        Canvas that = (Canvas)super.copy();
        that.controller = null;
        that.marginRow = (Row)this.marginRow.copy();
        that.marginColumn = (Column)this.marginColumn.copy();
        Row[] rowsCopy = this.getRows();
        for (int i = 0; i < rowsCopy.length; ++i) {
            rowsCopy[i] = (Row)rowsCopy[i].copy();
        }
        that.setRows(rowsCopy);
        Column[] columnsCopy = this.getColumns();
        for (int i = 0; i < columnsCopy.length; ++i) {
            columnsCopy[i] = (Column)columnsCopy[i].copy();
        }
        that.setColumns(columnsCopy);
        return that;
    }

    @Override
    public void syncTo(DomNode n) {
        if (!(n instanceof Canvas)) {
            throw new IllegalArgumentException("node should be a Canvas");
        }
        if (this.controller != null) {
            this.controller.syncTo((Canvas)n, new ArrayList<String>(), new HashMap<String, String>());
        } else {
            DomUtil.syncTo(this, n);
        }
    }

    @Override
    public void syncTo(DomNode n, List<String> exclude) {
        if (!(n instanceof Canvas)) {
            throw new IllegalArgumentException("node should be a Canvas");
        }
        if (this.controller != null) {
            this.controller.syncTo((Canvas)n, exclude, new HashMap<String, String>());
        } else {
            DomUtil.syncTo(this, n, exclude);
        }
    }

    @Override
    public List<Diff> diffs(DomNode node) {
        return DomUtil.getDiffs(this, node);
    }
}

